function sys=Systeme(varargin)
% SYSTEME retourne une matrice o chaque cellule contient les
%   caractristiques des sous-potentiels (marches, constantes)
%   constituant l'nergie potentielle totale ainsi que les vecteurs 
%   d'onde (entres et sorties) de l'objet physique tudi. 
%   Cet ensemble {nergie potentielle - objet physique} constitue 
%   le systme d'tude.
%
%   sys=Systeme(varargin)
%       >> varargin = sous-potentiels (nombre variable)
%       << sys = Energie potentielle totale + Vecteurs d'onde
%   Les sous-potentiels doivent tre crits dans l'ordre o ils
%   sont rencontrs par l'objet physique.
%
%   Olivier Pujol : septembre 2013
%
if (nargin<1), error('Mauvais nombre d''argument d''entre !');end
%
sys=cell(1,length(varargin));   % Initialisation
%
for k=1:length(varargin)
    sys{k+1}=varargin{k};
end
sys{1}=[get(varargin{1},'EnergiePotentielleEntree') ...
        get(varargin{end},'EnergiePotentielleSortie') ...
        get(varargin{1},'VecteurOndeEntree') ...
        get(varargin{end},'VecteurOndeSortie') ...
        get(varargin{1},'Position') ...
        get(varargin{end},'Position')];
%
return;